implementation module windowInternal2;

import StdClass;
import	StdInt, StdBool;
import	pointer, structure, windows, quickdraw, controls;
import	commonDef, windowAccess;
from	Picture			import Rect_in_region;
from	windowInternal	import Scroll_window, Align_thumb;
from	windowOpen		import Open_window;

import ScrollBars;

WindowPtrupdateRgn :== 122;

//	Setting the PictureDomain of a window with scroll bars and zoom box.

Set_window_domain	:: !Window !PictureDomain !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
Set_window_domain window=:(wPtr, hBar, vBar, pict, updArea, zoom) domain=:((xMin,yMin),(xMax,yMax)) f s tb
|	lx && ly	= Zoom_domain window domain dx` dy` s tb1;
|	lx			= Zoom_domain window domain dx` h	s tb1;
|	ly			= Zoom_domain window domain w	dy` s tb1;
				= Set_domain  window domain (hThumb, vThumb) f s tb3;
	where {
		(hControl, hScroll, hMax)	= hBar;
		(vControl, vScroll, vMax)	= vBar;
		(curSize, tb1)				= Window_size wPtr tb;
		(w, h)						= curSize;
		(hThumb,  tb2)				= GetScrollBarValue hControl hMax tb1;
		(vThumb,  tb3)				= GetScrollBarValue vControl vMax tb2;
		dx							= xMax - xMin;		dx`= dx + ScrollBarWidth;
		dy							= yMax - yMin;		dy`= dy + ScrollBarWidth;
		ly							= dy` < h;
		lx							= dx` < w;
	};

Zoom_domain	:: !Window !PictureDomain !Int !Int *s !*Toolbox -> (!Window, !*s, !*Toolbox);
Zoom_domain window=:(wPtr, hBar, vBar, pict, updArea, zoom) domain=:((xMin,yMin),(xMax,yMax)) w h s tb
	=	((wPtr, hBar`, vBar`, pict, updArea, (xMin, yMin)), s, tb4);
	where {
		(hControl, hScroll, hMax)	= hBar;
		(vControl, vScroll, vMax)	= vBar;
		hBar`						= (hControl, hScroll, xMax);
		vBar`						= (vControl, vScroll, yMax);
		tb1							= SizeWindow wPtr w h False tb;
		tb2							= SetWindowZoomState wPtr (xMin, xMax) (yMin, yMax) tb1;
		tb3							= RearrangeControls w h hControl xMax vControl yMax tb2;
		tb4							= Update_window [((0,0),(w,h))] wPtr tb3;
	};


Set_domain :: !Window !PictureDomain !(!Int, !Int) !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
Set_domain window=:(wPtr,hBar,vBar,picture,updArea,zoom) domain=:((xMin,yMin),(xMax,yMax)) thumbs f s tb
	=	Scroll_window window2 hThumb vThumb hThumb` vThumb` f s tb6;
	where {
		(hControl, hScroll, hMax)	= hBar;
		(vControl, vScroll, vMax)	= vBar;
		(hThumb, vThumb)			= thumbs;
		(curSize, tb1)				= Window_size wPtr tb;
		(w, h)						= curSize;
		tb2							= SetWindowZoomState wPtr (xMin, xMax) (yMin, yMax) tb1;
		tb3							= SetScrollBarMinAndMax hControl xMin xMax` xMax tb2;
		tb4							= SetScrollBarMinAndMax vControl yMin yMax` yMax tb3;
		w`							= w - ScrollBarWidth;
		h`							= h - ScrollBarWidth;
		xMax`						= xMax - w`;
		yMax`						= yMax - h`;
		(hThumb`, tb5)				= GetScrollBarValue hControl hMax tb4;
		(vThumb`, tb6)				= GetScrollBarValue vControl vMax tb5;
		zoom`						= (hThumb`, vThumb`);
		hBar`						= (hControl, hScroll, xMax);
		vBar`						= (vControl, vScroll, yMax);
		window2						= (wPtr, hBar`, vBar`, picture, updArea, zoom`);
	};


//	Setting the PictureDomain of a fixed size window.

Change_fixed_window_domain :: !PictureDomain !WindowPtr !(WindowHandle s) !*Toolbox
	->	(!WindowHandle s, !*Toolbox);
Change_fixed_window_domain	domain=:((hMin, vMin), (hMax, vMax)) prevWindow
							( wDef	=:FixedWindow id pos` title d u as,
							  window=:(wPtr, hBar, vBar, pict, updArea, zoom)) tb
|	dh < r - l
&&	dv < b - t`		= ((wDef, window), tb3);
					= Open_window wDef` prevWindow (DisposeWindow wPtr tb2);
	where {
		tb3				= Update_window [((0,0), (dh,dv))] wPtr (SizeWindow wPtr dh dv False tb2);
		wDef`			= ScrollWindow id pos title
							(ScrollBar (Thumb hMin) (Scroll 10)) (ScrollBar (Thumb vMin) (Scroll 10))
							domain (WindowDefGetFinalMinimumSize wDef) (dh, dv) u as;
		pos				= (x - WindowScreenBorder, y - (TitleBarWidth + WindowScreenBorder));
		dh				= hMax - hMin;
		dv				= vMax - vMin;
		t`				= t + TitleBarWidth;
		(x,y)			= glob;
		(glob, tb2)		= InGrafport wPtr (LocalToGlobal (0,0)) tb1;
		(l,t, r,b, tb1)	= QScreenRect tb;
	};


//	Growing windows.

Update_grow_window :: !WindowPtr !ControlHandle !Int !ControlHandle !Int !Int !Int
	!UpdateArea !(!Int,!Int) !(!Int,!Int) !(!Int,!Int) !*Toolbox -> (!*Toolbox, !UpdateArea);
Update_grow_window	wPtr hControl hScroll vControl vScroll hMax vMax updArea 
					oldSize=:(oldW,oldH) oldThumbs=:(oldHt,oldVt) newSize=:(newW,newH) tb
	| oldHt - newHt > 0 || oldVt - newVt > 0
		= Update_grown_window wPtr tb2 wholeWindow [] [after];
	| gw && gh	
		= Update_grown_window wPtr tb2 [((oldW`,0),(newW,oldH`)),((0,oldH`),newSize)]
												domain updArea;
	| gw
		= Update_grown_window wPtr tb2 [((oldW`,0),newSize),((0,newH`),newSize)] domain updArea;
	| gh
		= Update_grown_window wPtr tb2 [((0,oldH`),newSize),((newW`,0),newSize)] domain updArea;
		= Update_grown_window wPtr tb2 [((newW`,0),(newW,newH`)),((0,newH`),newSize)] domain updArea;
	where {
		wholeWindow	= [((0,0), newSize)];
		domain		= SubGrowRect before after;
		before		= (oldThumbs, (oldHt + oldW`, oldVt + oldH`));
		after		= (newThumbs, (newHt + newW`, newVt + newH`));
		newThumbs	= (newHt, newVt);
		(newVt, tb2)= GetScrollBarValue vControl vMax (AlignControl vControl vScroll vMax tb1);
		(newHt, tb1)= GetScrollBarValue hControl hMax (AlignControl hControl hScroll hMax tb);
		oldW`		= oldW - ScrollBarWidth;
		newW`		= newW - ScrollBarWidth;
		oldH`		= oldH - ScrollBarWidth;
		newH`		= newH - ScrollBarWidth;
		gh			= newH > oldH;
		gw			= newW > oldW;
	};

Update_grown_window wPtr tb rects upd1 upd2
	:==	(Update_window rects wPtr tb, AppendUpdateAreas upd1 upd2);

AlignControl :: !ControlHandle !Int !Int !*Toolbox -> *Toolbox;
AlignControl control scroll max2 tb
	= 	SetScrollBarValue control (Align_thumb thumb min max scroll) max2 tb3;
	where {
		(thumb, tb1)= GetScrollBarValue control max2 tb;
		(min,   tb2)= GetScrollBarMin   control max2 tb1;
		(max,   tb3)= GetScrollBarMax   control max2 tb2;
	};


SubGrowRect	:: !Rectangle !Rectangle -> UpdateArea;
SubGrowRect before=:(b1=:(bXmin, bYmin), b2=:(bXmax, bYmax))
			after =:(a1=:(aXmin, aYmin), a2=:(aXmax, aYmax))
|	bXmin == aXmin
&&	bYmin == aYmin	= EqualLeftTopSubGrowRect before after r1 r2;
|	bXmax == aXmax
&&	bYmax == aYmax	= NoEmptyRectangles [r3, r4];
					= NoEmptyRectangles [r1, r2, r3, r4];
	where {
		r1= ((bXmax, bYmin), (aXmax, bYmax));
		r2= ((bXmin, bYmax), a2);
		r3= ((aXmin, bYmin), (bXmin, aYmax));
		r4= (a1,			 (aXmax, bYmin));
	};

EqualLeftTopSubGrowRect	:: !Rectangle !Rectangle !Rectangle !Rectangle -> UpdateArea;
EqualLeftTopSubGrowRect before=:(b1=:(bXmin, bYmin), b2=:(bXmax, bYmax))
						after =:(a1=:(aXmin, aYmin), a2=:(aXmax, aYmax)) rightArea downArea
|	isRight && isDown	= NoEmptyRectangles [rightArea, downArea];
|	isRight				= NoEmptyRectangles [rightArea];
|	isDown				= NoEmptyRectangles [downArea];
						= [];
	where {
		isDown = aYmax > bYmax;
		isRight= aXmax > bXmax;
	};
	
NoEmptyRectangles :: !UpdateArea -> UpdateArea;
NoEmptyRectangles [r=:((xMin, yMin), (xMax, yMax)) : rs]
|	xMin == xMax || yMin == yMax	= rs`;
									= [r : rs`];
	where {
		rs` = NoEmptyRectangles rs;
	};
NoEmptyRectangles rs = rs;

Update_window :: !UpdateArea !WindowPtr !*Toolbox -> *Toolbox;
Update_window [] _ tb = tb;
Update_window updArea wPtr tb
	= 	QSetPort port tb3;
	where {
		(port, tb1)	= QGetPort tb;
		tb2			= QSetPort wPtr tb1;
		tb3			= SetInvalRects updArea tb2;
	};

SetInvalRects :: !UpdateArea !*Toolbox -> *Toolbox;
SetInvalRects [((l,t),(r,b)) : rs] tb = SetInvalRects rs (InvalRect (l,t,r,b) tb);
SetInvalRects rs tb = tb;
	
Update_val_window :: !UpdateArea !WindowPtr !*Toolbox -> *Toolbox;
Update_val_window [] _ tb = tb;
Update_val_window updArea wPtr tb
	= 	QSetPort port tb3;
	where {
		(port, tb1)	= QGetPort tb;
		tb2			= QSetPort wPtr tb1;
		tb3			= SetValidRects updArea tb2;
	};

SetValidRects :: !UpdateArea !*Toolbox -> *Toolbox;
SetValidRects [((l,t),(r,b)) : rs] tb = SetValidRects rs (ValidRect (l,t,r,b) tb);
SetValidRects _ tb = tb;
	
RearrangeControl :: !ControlHandle !Int !Int !Int !Int !Int !Int !*Toolbox -> *Toolbox;
RearrangeControl control h v width height max max2 tb
		= tb6;
	where {
		(address, tb1)	= LoadLong control tb;
		tb2				= StoreByte (address + 16) 0 tb1;
		tb3				= MoveControl control h v tb2;
		tb4				= SizeControl control width height tb3;
		tb5				= SetScrollBarMax control max max2 tb4;
		tb6				= StoreByte (address + 16) 255 tb5;
	};

RearrangeControls	:: !Int !Int !ControlHandle !Int !ControlHandle !Int !*Toolbox -> *Toolbox;
RearrangeControls w h hControl hMax vControl vMax tb
	= 	RearrangeControl hControl (-1) (h - ScrollBarWidth) (w - 13) 16 hMax` hMax (
		RearrangeControl vControl (w - ScrollBarWidth) (-1) 16 (h - 13) vMax` vMax tb);
	where {
		hMax`= hMax - (w - ScrollBarWidth);
		vMax`= vMax - (h - ScrollBarWidth);
	};

Do_grow_window	:: !Window !MinimumWindowSize !Int !Int !*Toolbox -> (!Window, !*Toolbox);
Do_grow_window window=:(wPtr, hBar, vBar, pict, updArea, zoom) minSize h v tb
	= 	Do_grow_window2 window minSize h v size (hThumb, vThumb) (hMin, vMin) tb5;
	where {
		(hControl, hScroll, hMax)	= hBar;
		(vControl, vScroll, vMax)	= vBar;
		(size,  tb1)				= Window_size wPtr tb;
		(hMin,  tb2)				= GetScrollBarMin hControl hMax tb1;
		(vMin,  tb3)				= GetScrollBarMin vControl vMax tb2;
		(hThumb,tb4)				= GetScrollBarValue hControl hMax tb3;
		(vThumb,tb5)				= GetScrollBarValue vControl vMax tb4;
	};

from StdMisc import abort;

Do_grow_window2 :: !Window !MinimumWindowSize !Int !Int !(!Int, !Int) !(!Int, !Int) !(!Int, !Int) !*Toolbox
	->	(!Window, !*Toolbox);
Do_grow_window2	window=:(wPtr, hBar=:(hControl,hScroll,hMax), vBar=:(vControl,vScroll,vMax), pict, updArea, zoom)
				minSize=:(minW, minH) h v oldSize oldThumbs=:(hThumb,vThumb)
				domainTop=:(hMin,vMin) tb
	| newW <> 0 && newH <> 0	= ((wPtr, hBar, vBar, pict, updArea1, zoom), tb2);
								= (window, tb1);
	where {
		(tb2, updArea1) =
			Update_grow_window wPtr hControl hScroll vControl vScroll hMax vMax updArea oldSize oldThumbs newSize (
				RearrangeControls newW newH hControl hMax vControl vMax (
					SizeWindow wPtr newW newH False tb1));
		(newW, newH)	= newSize;
		(newSize, tb1)	= GrowWindow wPtr h v (minW`, minH`, maxW, maxH32767) tb;
		minW`				= minW + ScrollBarWidth;
		minH`				= minH + ScrollBarWidth;
		maxW				= inc (hMax - hMin + ScrollBarWidth);
		maxH32767			= if (maxH<=32767) maxH 32767;		
		maxH				= inc (vMax - vMin + ScrollBarWidth);
	};


/*	UpdateArea handling. Naive version of merging update areas. 
	Check if it's better to avoid overlapping rectangles.
*/

AppendUpdateAreas	:: !UpdateArea !UpdateArea -> UpdateArea;
AppendUpdateAreas [y : ys]	xs = [y : AppendUpdateAreas ys xs];
AppendUpdateAreas ys			xs = xs;


//	Determine whether an update is required for this window.

WindowSetUpdateArea	:: !Rect !Window !*Toolbox -> (!Window, !*Toolbox);
WindowSetUpdateArea (l,t,r,b) window=:(wPtr, hBar, vBar, pict, [], zoom) tb
|	doUpdate	= ((wPtr, hBar, vBar, pict, updArea, zoom), tb13);
				= (window, tb13);
	where {
		(hControl, hScroll, hMax)	= hBar;
		(vControl, vScroll, vMax)	= vBar;
		(updRgn,	tb1)			= LoadLong (wPtr + WindowPtrupdateRgn) tb;
		(updRgnRect,tb2)			= LoadLong updRgn tb1;
		rect						= 2 + updRgnRect;
		(top,		tb3)			= LoadWord rect			tb2;
		(left,		tb4)			= LoadWord (rect + 2)	tb3;
		(bottom,	tb5)			= LoadWord (rect + 4)	tb4;
		(right,		tb6)			= LoadWord (rect + 6)	tb5;
		(vThumb,	tb7)			= GetScrollBarValue vControl vMax tb6;
		(hThumb, 	tb8)			= GetScrollBarValue hControl hMax tb7;
		(locMax, 	tb9)			= InGrafport wPtr (GlobalToLocal (right,bottom)) tb8;
		(locMin, 	tb10)			= InGrafport wPtr (GlobalToLocal (left, top)) tb9;
		(locLeft,  locTop)			= locMin;
		(locRight, locBot)			= locMax;
		updArea						= [(	(hThumb + locLeft,			vThumb + locTop),
											(hThumb + Min r locRight ,	vThumb + Min b locBot))];
		(rectMax,	tb11)			= InGrafport wPtr (LocalToGlobal (dec r,dec b)) tb10;
		(rectMin,	tb12)			= InGrafport wPtr (LocalToGlobal (inc l,inc t)) tb11;
		(doUpdate,	tb13)			= Rect_in_region (rectMin, rectMax) updRgn tb12;
	};
WindowSetUpdateArea _ window tb = (window, tb);


//	Zooming windows.

Store_w_state_data :: !WindowPtr !Rect !*Toolbox -> *Toolbox;
Store_w_state_data wPtr (left, top, right, bottom) tb
	=	tb6;
	where {
		(h, tb1)	= LoadLong (wPtr + 130)	tb;
		(dh,tb2)	= DereferenceHandle h	tb1;
		s0			= (h, 8 + dh);
		(s1,tb3)	= Append_word s0 top	tb2;
		(s2,tb4)	= Append_word s1 left	tb3;
		(s3,tb5)	= Append_word s2 bottom	tb4;
		(_,tb6)		= Append_word s3 right	tb5;
	};

SetWindowZoomState :: !WindowPtr !(!Int, !Int) !(!Int, !Int) !*Toolbox -> *Toolbox;
SetWindowZoomState wPtr (hMin,hMax) (vMin,vMax) tb
	=	Store_w_state_data wPtr (left,top, right,bottom) tb1;
	where {
		dX		= hMax - hMin + ScrollBarWidth;
		dY		= vMax - vMin + ScrollBarWidth;
		left	= sL + WindowScreenBorder;
		top		= sT + WindowScreenBorder + MenuBarWidth + TitleBarWidth;
		right	= Min (left + dX) (sR - WindowScreenBorder);
		bottom	= Min (top  + dY) (sB - WindowScreenBorder);
		(sL,sT, sR,sB, tb1) = QScreenRect tb;
	};


Zoom_window	:: !Window !Int !Int !Int !*Toolbox -> (!Window, !*Toolbox);
Zoom_window window=:(wPtr, hBar, vBar, pict, updArea, zoom) h v whereMouse tb
	|	doZoom	= Zoom_window_in_out window whereMouse globPos tb2;
				= (window, tb1);
	where {
		(doZoom,  tb1) = TrackBox wPtr h v whereMouse tb;
		(globPos, tb2) = InGrafport wPtr (LocalToGlobal (h,v)) tb1;
	};

Zoom_window_in_out :: !Window !Int !WindowPos !*Toolbox -> (!Window, !*Toolbox);
Zoom_window_in_out window=:(wPtr, hBar, vBar, pict, updArea, zoom) InZoomOut globLoc tb
	= 	Zoom_window_out window (hThumb, vThumb) globLoc tb2;
	where {
		(hControl, hScroll, hMax)	= hBar;
		(vControl, vScroll, vMax)	= vBar;
		(hThumb, tb1)				= GetScrollBarValue hControl hMax tb;
		(vThumb, tb2)				= GetScrollBarValue vControl vMax tb1;
	};
Zoom_window_in_out window=:(wPtr, hBar, vBar, pict, updArea, zoom) InZoomIn globLoc tb
	= 	Zoom_window_in window minH maxH minV maxV (hThumb, vThumb) globLoc tb6;
	where {
		(hControl, hScroll, hMax)	= hBar;
		(vControl, vScroll, vMax)	= vBar;
		(minH,  tb1)= GetScrollBarMin	hControl hMax tb;
		(minV,  tb4)= GetScrollBarMin	vControl vMax tb3;
		(maxH,  tb2)= GetScrollBarMax	hControl hMax tb1;
		(maxV,  tb5)= GetScrollBarMax	vControl vMax tb4;
		(hThumb,tb3)= GetScrollBarValue hControl hMax tb2;
		(vThumb,tb6)= GetScrollBarValue vControl vMax tb5;
	};

Zoom_window_out :: !Window !(!Int, !Int) !WindowPos !*Toolbox -> (!Window, !*Toolbox);
Zoom_window_out window=:(wPtr, hBar, vBar, pict, updArea, zoom) zoom`=:(hThumb, vThumb) globLoc tb
	=	((wPtr, hBar, vBar, pict, updArea`, zoom`), tb8);
	where {
		(hControl, hScroll, hMax)	= hBar;
		(vControl, vScroll, vMax)	= vBar;
		(oldSize,  tb1)				= Window_size wPtr tb;
		tb2							= InGrafport2 wPtr (ZoomWindow wPtr InZoomOut True) tb1;
		(newSize,  tb3)				= Window_size wPtr tb2;
		(w, h)						= newSize;
		(globLoc`, tb4)				= InGrafport  wPtr (LocalToGlobal (0,0)) tb3;
		tb5							= RearrangeControls w h hControl hMax vControl vMax tb4;
		(hThumb`, tb6)				= GetScrollBarValue hControl hMax tb5;
		(vThumb`, tb7)				= GetScrollBarValue vControl vMax tb6;
		(tb8, updArea`) =
			ZoomOutUpdateArea wPtr globLoc globLoc` zoom` (hThumb`, vThumb`) oldSize newSize tb7;
	};

ZoomOutUpdateArea :: !WindowPtr !WindowPos !WindowPos !(!Int, !Int) !(!Int, !Int) !(!Int, !Int)
					 !(!Int, !Int) !*Toolbox
	->	(!*Toolbox, !UpdateArea);
ZoomOutUpdateArea wPtr	oldLoc		=:(globX,	globY)
						newLoc		=:(globX`,	globY`)
						oldThumbs	=:(hThumb,	vThumb)
						newThumbs	=:(hThumb`,	vThumb`)
						oldSize		=:(oldW,	oldH)
						newSize		=:(newW,	newH) tb
|	globX  <>  globX`	|| globY  <>  globY`
||	hThumb <> hThumb`	|| vThumb <> vThumb`
	= (Update_window [((0,0),newSize)] wPtr tb,
		[(newThumbs, (hThumb` + newW - ScrollBarWidth, vThumb` + newH - ScrollBarWidth))]);
|	newW > oldW
	= ZoomOutUpdateArea2 wPtr oldW oldH newW newH (oldW - ScrollBarWidth) newW True newThumbs tb;
	= ZoomOutUpdateArea2 wPtr oldW oldH newW newH newW newW False newThumbs tb;

ZoomOutUpdateArea2 :: !WindowPtr !Int !Int !Int !Int !Int !Int !Bool !(!Int, !Int) !*Toolbox
	->	(!*Toolbox, !UpdateArea);
ZoomOutUpdateArea2 wPtr oldW oldH newW newH updLeft updRight widthIncr (hT, vT) tb
	| newH > oldH
	= 	ZoomUpdateArea wPtr updLeft 0 updRight oldH
							0 (oldH - ScrollBarWidth) newW newH widthIncr True  hT vT tb;
	= 	ZoomUpdateArea wPtr updLeft 0 updRight newH
							0 (newH - ScrollBarWidth) newW newH widthIncr False hT vT tb;

ZoomUpdateArea	:: !WindowPtr !Int !Int !Int !Int !Int !Int !Int !Int !Bool !Bool !Int Int !*Toolbox
	->	(!*Toolbox, !UpdateArea);
ZoomUpdateArea wPtr	left1 top1 right1 bottom1
					left2 top2 right2 bottom2
					wIncr hIncr hThumb vThumb tb
| wIncr && hIncr	= (Update_val_window [((0,0),(left1, top2))] wPtr tb, [r1, r2]);
| wIncr				= (Update_window
							[((left1`,bottom1``), (left1,bottom1`))] wPtr
							(Update_val_window [((0,0),(left1, bottom1`))] wPtr tb), [r1]);
| hIncr				= (Update_window 
							[((right1`,bottom1``),(right1,bottom1`))] wPtr
							(Update_val_window [((0,0),(right1,bottom1`))] wPtr tb), [r2]);
					= (tb, [(lt, lt)]);
	where {
		r1		= (lt,	(hThumb + right1`, vThumb + bottom1`));
		r2		= ((hThumb + left2, vThumb + top2), (hThumb + right2`, vThumb + bottom2`));
		right1`	= right1 - ScrollBarWidth;	bottom1` = bottom1  - ScrollBarWidth;
		right2`	= right2 - ScrollBarWidth;	bottom2` = bottom2  - ScrollBarWidth;
		left1`	= left1  - ScrollBarWidth;	bottom1``= bottom1` - ScrollBarWidth;
		lt		= (hThumb + left1, vThumb + top1);
	};

Zoom_window_in	:: !Window !Int !Int !Int !Int !(!Int, !Int) !WindowPos !*Toolbox
	->	(!Window, !*Toolbox);
Zoom_window_in window=:(wPtr, hBar, vBar, pict, updArea, zoom) minH maxH minV maxV thumbs globLoc tb
	=	((wPtr, hBar, vBar, pict, updArea`, zoom), tb10);
	where {
		(hControl, hScroll, hMax)	= hBar;
		(vControl, vScroll, vMax)	= vBar;
		(oldH, oldV)				= zoom;
		(oldSize, tb1)	= Window_size wPtr tb;
		tb2				= InGrafport2 wPtr (ZoomWindow wPtr InZoomIn True) tb1;
		(newSize, tb3)	= Window_size wPtr tb2;
		(w, h)			= newSize;
		(globLoc`, tb4)	= InGrafport wPtr (LocalToGlobal (0,0)) tb3;
		tb5				= RearrangeControls w h hControl hMax vControl vMax tb4;
		tb6				= Restore_thumb hControl oldH minH maxH hMax tb5;
		tb7				= Restore_thumb vControl oldV minV maxV vMax tb6;
		(newH, tb8)		= GetScrollBarValue hControl hMax tb7;
		(newV, tb9)		= GetScrollBarValue vControl vMax tb8;
		(tb10,updArea`)	=
			ZoomInUpdateArea wPtr globLoc globLoc` thumbs (newH,newV) oldSize newSize tb9;
	};

ZoomInUpdateArea :: !WindowPtr !WindowPos !WindowPos !(!Int, !Int) !(!Int, !Int) !(!Int, !Int)
							!(!Int, !Int) !*Toolbox
	->	(!*Toolbox, !UpdateArea);
ZoomInUpdateArea wPtr	oldLoc		=:(globX,	globY)
						newLoc		=:(globX`,	globY`)
						oldThumbs	=:(hThumb,	vThumb)
						newThumbs	=:(hThumb`,	vThumb`)
						oldSize		=:(oldW,	oldH)
						newSize		=:(newW,	newH) tb
|	newW > oldW
||	newH > oldH
	= 	ZoomOutUpdateArea wPtr oldLoc newLoc oldThumbs newThumbs oldSize newSize tb;
|	globX  == globX`
&&	globY  == globY`
&&	hThumb == hThumb`
&&	vThumb == vThumb`
	=	(tb, [(newThumbs, newThumbs)]);
	=	(Update_window [((0,0),newSize)] wPtr tb,
		 [(newThumbs, (hThumb` + newW - ScrollBarWidth, vThumb` + newH - ScrollBarWidth))]);

Restore_thumb :: !ControlHandle !Int !Int !Int !Int !*Toolbox -> *Toolbox;
Restore_thumb control thumb min max max2 tb 
	| min <> max
		= tb;
		= SetScrollBarValue control thumb max2 tb;

SetScrollBarMinAndMax control min max max2 t0
	| max2>32767
		= SetScrollBarMinAndMax control (min>>1) (max>>1) (max2>>1) t0;
		= SetCtlMin control min (SetCtlMax control max t0);

SetScrollBarMax control max max2 t0
	| max2>32767
		= SetScrollBarMax control (max>>1) (max2>>1) t0;
		= SetCtlMax control max t0;

